/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.filesystem;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jemu.core.device.filesystem.DskFile;
import jemu.core.device.filesystem.DskManager;
import jemu.core.device.filesystem.DskManagerConsole;
import jemu.core.device.filesystem.DskMaster;
import jemu.core.device.filesystem.DskType;
import jemu.core.device.filesystem.TransferHelper;
import jemu.settings.Settings;

public class DskManagerEditor
extends JInternalFrame {
    public static String[] drive = new String[]{"0", "1", "2", "3"};
    public static int selectedDrive = 0;
    protected JFrame theFrame = new JFrame();
    DskManager dm = new DskManager();
    protected DskFile dskFile;
    LinkedHashMap<String, ByteArrayOutputStream> list;
    Map<String, Integer> users;
    JPanel bottomMenu = new JPanel();
    JPanel infoContent = new JPanel();
    JTextArea info = new JTextArea();
    private JButton buttonNew = new JButton("New");
    private JButton buttonLoad = new JButton("Load");
    public JTable table;
    DefaultTableModel model = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            String avant = (String)DskManagerEditor.this.model.getValueAt(row, column);
            String apres = (String)value;
            apres = DskManagerEditor.this.dskFile.master.realname2realname(apres);
            try {
                DskManagerEditor.this.dm.renameFile(DskManagerEditor.this.dskFile, avant, apres);
                super.setValueAt(apres, row, column);
                DskManagerEditor.this.updateTable();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    };
    public int freeSize = 0;
    private TransferHelper transferHelper;
    private static DskManagerEditor jFrame;

    public void selectDrive(int seldrive) {
        selectedDrive = seldrive;
        String file = Settings.get("file.drive" + drive[selectedDrive], null);
        if (file != null) {
            File fileToLoad = new File(file);
            try {
                this.dskFile = this.dm.loadDsk(fileToLoad.getParentFile(), fileToLoad.getName());
                this.updateTable();
                Settings.set("last_path", fileToLoad.getParent() + "/");
                Settings.set("file.drive" + drive[selectedDrive], fileToLoad.getAbsolutePath());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public DskManagerEditor() {
        super("CPC Dsk Manager");
        URL iconURL = this.getClass().getResource("cpc.png");
        final ImageIcon icon = new ImageIcon(iconURL);
        this.setLayout(new BorderLayout());
        final Font font2 = new Font("Monospaced", 1, 12);
        final Font font = new Font("Monospaced", 0, 12);
        this.table = new JTable(this.model){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                DefaultTableCellRenderer renderRight = new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (column != 1) {
                            this.setFont(font);
                            this.setForeground(Color.BLACK);
                            this.setBackground(isSelected ? Color.gray : Color.white);
                        } else {
                            this.setForeground(isSelected ? Color.yellow : Color.blue);
                            this.setBackground(isSelected ? Color.blue : Color.white);
                            this.setOpaque(true);
                            this.setFont(font2);
                        }
                        return this;
                    }
                };
                if (column == 2) {
                    renderRight.setHorizontalAlignment(4);
                } else if (column > 2 || column == 1) {
                    renderRight.setHorizontalAlignment(0);
                } else {
                    renderRight.setHorizontalAlignment(2);
                }
                return renderRight;
            }
        };
        this.info.setFont(font);
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        this.transferHelper = new TransferHelper(this);
        this.table.setTransferHandler(this.transferHelper);
        this.table.setDragEnabled(true);
        this.table.setDropMode(DropMode.USE_SELECTION);
        this.table.setFillsViewportHeight(true);
        this.table.setBackground(Color.LIGHT_GRAY);
        this.infoContent.setLayout(new BorderLayout());
        this.infoContent.add((Component)scrollPane, "Center");
        this.infoContent.add((Component)this.table.getTableHeader(), "North");
        this.info.setPreferredSize(new Dimension(-1, 20));
        this.infoContent.add((Component)this.info, "South");
        this.info.setDisabledTextColor(Color.BLACK);
        this.info.setBackground(Color.LIGHT_GRAY);
        this.info.setEnabled(false);
        this.add((Component)this.infoContent, "Center");
        this.add((Component)this.bottomMenu, "South");
        this.bottomMenu.setLayout(new BorderLayout());
        this.bottomMenu.setBackground(Color.LIGHT_GRAY);
        this.bottomMenu.add((Component)this.buttonNew, "West");
        this.bottomMenu.add((Component)this.buttonLoad, "East");
        this.buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setDialogTitle("Create new dsk file");
                String path = Settings.get("last_path", null);
                if (path != null) {
                    jfc.setCurrentDirectory(new File(path));
                }
                FileFilter ff = new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "CPC DSK files (*.dsk)";
                    }

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().toLowerCase().endsWith(".dsk");
                    }
                };
                jfc.addChoosableFileFilter(ff);
                jfc.setFileFilter(ff);
                int response = jfc.showSaveDialog(DskManagerEditor.this);
                if (response == 0) {
                    File fileToSave = jfc.getSelectedFile();
                    if (!fileToSave.getName().toLowerCase().endsWith(".dsk")) {
                        fileToSave = new File(fileToSave.getParent(), fileToSave.getName() + ".dsk");
                    }
                    try {
                        Object[] values = new Object[]{DskType.PARADOS80, DskType.PARADOS41, DskType.PARADOS40D, DskType.SS40, DskType.DOSD2, DskType.DOSD10, DskType.DOSD20, DskType.DOSD40, DskType.SDOS, DskType.SYSTEM, DskType.VORTEX};
                        DskType value = DskType.SS40;
                        Object dialogResult = JOptionPane.showInputDialog(DskManagerEditor.this, "Format DOSD2 (or else let SS40)", "WARNING", -1, icon, values, (Object)value);
                        if (DskType.PARADOS80.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.PARADOS80);
                        } else if (DskType.PARADOS41.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.PARADOS41);
                        } else if (DskType.PARADOS40D.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.PARADOS40D);
                        } else if (DskType.SS40.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.SS40);
                        } else if (DskType.SYSTEM.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.SYSTEM);
                        } else if (DskType.VORTEX.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.VORTEX);
                        } else if (DskType.DOSD2.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.DOSD2);
                        } else if (DskType.DOSD10.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.DOSD10);
                        } else if (DskType.DOSD20.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.DOSD20);
                        } else if (DskType.DOSD40.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.DOSD40);
                        } else if (DskType.SDOS.equals(dialogResult)) {
                            DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.newDsk(fileToSave.getParentFile(), fileToSave.getName(), DskType.SDOS);
                        }
                        if (dialogResult != null) {
                            DskManagerEditor.this.updateTable();
                            Settings.set("last_path", fileToSave.getParent() + "/");
                            Settings.set("file.drive" + drive[selectedDrive], fileToSave.getAbsolutePath());
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.buttonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                String path = Settings.get("last_path", null);
                if (path != null) {
                    jfc.setCurrentDirectory(new File(path));
                }
                jfc.setDialogTitle("Load a dsk file");
                FileFilter ff = new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "CPC DSK files (*.dsk)";
                    }

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().toLowerCase().endsWith(".dsk");
                    }
                };
                jfc.addChoosableFileFilter(ff);
                jfc.setFileFilter(ff);
                int response = jfc.showOpenDialog(DskManagerEditor.this);
                if (response == 0) {
                    File fileToLoad = jfc.getSelectedFile();
                    try {
                        DskManagerEditor.this.dskFile = DskManagerEditor.this.dm.loadDsk(fileToLoad.getParentFile(), fileToLoad.getName());
                        if (DskManagerEditor.this.dskFile == null || DskManagerEditor.this.dskFile.master.type == null) {
                            DskManagerEditor.this.ejectTable();
                            JOptionPane.showMessageDialog(DskManagerEditor.this, "Disk unknown");
                        } else {
                            DskManagerEditor.this.updateTable();
                            Settings.set("last_path", jfc.getSelectedFile().getParent() + "/");
                            Settings.set("file.drive" + drive[selectedDrive], jfc.getSelectedFile().getAbsolutePath());
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && DskManagerEditor.this.table.getSelectedRows().length > 0) {
                    for (int t : DskManagerEditor.this.table.getSelectedRows()) {
                        try {
                            DskManagerEditor.this.dm.eraseFile(DskManagerEditor.this.dskFile, (String)DskManagerEditor.this.table.getValueAt(t, 0));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        DskManagerEditor.this.updateTable();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (e.getKeyCode() == 67 && (e.getModifiers() & 2) != 0 && DskManagerEditor.this.table.getSelectedRows().length > 0) {
                    Transferable contents = DskManagerEditor.this.transferHelper.createTransferable(DskManagerEditor.this.table);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
                }
                if (e.getKeyCode() == 86 && (e.getModifiers() & 2) != 0) {
                    Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                    DskManagerEditor.this.transferHelper.importDataTransferable(transferable);
                }
            }
        });
        this.model.addColumn("Internal");
        this.model.addColumn("Filename");
        this.model.addColumn("Size");
        this.model.addColumn("Type");
        this.model.addColumn("User");
        this.model.addColumn("Attributes");
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setMinWidth(0);
        columnModel.getColumn(0).setMaxWidth(0);
        columnModel.getColumn(0).setWidth(0);
        columnModel.getColumn(1).setMinWidth(110);
        columnModel.getColumn(1).setMaxWidth(110);
        columnModel.getColumn(1).setWidth(110);
        columnModel.getColumn(2).setMinWidth(50);
        columnModel.getColumn(2).setMaxWidth(50);
        columnModel.getColumn(2).setWidth(50);
        columnModel.getColumn(3).setMinWidth(50);
        columnModel.getColumn(3).setMaxWidth(50);
        columnModel.getColumn(3).setWidth(50);
        columnModel.getColumn(4).setPreferredWidth(30);
        columnModel.getColumn(5).setPreferredWidth(30);
        String file = Settings.get("file.drive" + drive[selectedDrive], null);
        if (file != null) {
            File fileToLoad = new File(file);
            try {
                this.dskFile = this.dm.loadDsk(fileToLoad.getParentFile(), fileToLoad.getName());
                this.updateTable();
                Settings.set("last_path", fileToLoad.getParent() + "/");
                Settings.set("file.drive" + drive[selectedDrive], fileToLoad.getAbsolutePath());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void updateTable() throws IOException {
        this.model.setRowCount(0);
        if (this.dskFile == null) {
            return;
        }
        this.list = this.dm.listFiles(this.dskFile);
        this.users = this.dm.getUserPerFile(this.dskFile);
        this.freeSize = 0;
        if (null != this.dskFile.master.type) {
            switch (this.dskFile.master.type) {
                case PARADOS80: {
                    this.freeSize = 396;
                    break;
                }
                case PARADOS41: {
                    this.freeSize = 203;
                    break;
                }
                case PARADOS40D: {
                    this.freeSize = 396;
                    break;
                }
                case SS40: {
                    this.freeSize = 178;
                    break;
                }
                case SYSTEM: {
                    this.freeSize = 169;
                    break;
                }
                case VORTEX: {
                    this.freeSize = 704;
                    break;
                }
                case DOSD2: {
                    this.freeSize = 712;
                    break;
                }
                case DOSD10: {
                    this.freeSize = 796;
                    break;
                }
                case DOSD20: {
                    this.freeSize = 792;
                    break;
                }
                case DOSD40: {
                    this.freeSize = 396;
                    break;
                }
                case SDOS: {
                    this.freeSize = 396;
                    break;
                }
            }
        }
        ArrayList<String> filenames = new ArrayList<String>(this.list.keySet());
        Collections.sort(filenames);
        for (String filename : filenames) {
            Integer user = this.users.get(filename);
            byte[] content = this.list.get(filename).toByteArray();
            DskMaster cfr_ignored_0 = this.dskFile.master;
            boolean isBinary = DskMaster.CheckAMSDOS(content);
            int type = 0;
            String Type2 = "BAS";
            if (isBinary) {
                type = content[18] & 0xFF;
                switch (type) {
                    case 0: {
                        Type2 = "BAS";
                        break;
                    }
                    case 1: {
                        Type2 = "BPT";
                        break;
                    }
                    case 2: {
                        Type2 = "BIN";
                        break;
                    }
                    default: {
                        Type2 = "UNK";
                        break;
                    }
                }
            } else {
                Type2 = "ASC";
            }
            boolean Protected = false;
            boolean System2 = false;
            for (int i = 0; i < filename.length(); ++i) {
                int check = filename.charAt(i) & 0xFF;
                if (i == 9 && check > 127) {
                    Protected = true;
                }
                if (i != 10 || check <= 127) continue;
                System2 = true;
            }
            String attr = Protected ? "R " : "  ";
            attr = System2 ? attr + "S" : attr + " ";
            int taille = this.list.get(filename).size() / 1024;
            if (this.list.get(filename).size() % 1024 > 0) {
                ++taille;
            }
            if (this.dskFile.master.type == DskType.PARADOS80 || this.dskFile.master.type == DskType.PARADOS40D || this.dskFile.master.type == DskType.DOSD2 || this.dskFile.master.type == DskType.DOSD20 || this.dskFile.master.type == DskType.DOSD40 || this.dskFile.master.type == DskType.SDOS || this.dskFile.master.type == DskType.VORTEX) {
                if (taille / 2 * 2 != taille) {
                    ++taille;
                }
                if (this.dskFile.master.type == DskType.VORTEX && taille / 4 * 4 != taille) {
                    taille += 2;
                }
            }
            String showname = "";
            for (int i = 0; i < filename.length(); ++i) {
                int a = filename.charAt(i) & 0x7F;
                showname = showname + (char)a;
            }
            this.model.addRow(new Object[]{filename, showname, taille + "kb", Type2, "User: " + user, attr});
            this.freeSize -= taille;
        }
        if (this.dskFile.master.type == null) {
            this.ejectTable();
        } else {
            this.info.setText("Free: " + this.freeSize + "kb");
            this.setTitle("CPC File System - " + this.dskFile.file.getName() + " - " + (Object)((Object)this.dskFile.master.type));
            if (this.theFrame != null) {
                this.theFrame.setTitle(this.getTitle());
            }
            this.table.setBackground(Color.WHITE);
        }
    }

    public JInternalFrame getDskManager() {
        this.setVisible(true);
        return this;
    }

    public JFrame getDskManagerFrame() {
        this.setVisible(true);
        this.theFrame.setDefaultCloseOperation(3);
        this.theFrame.setLayout(new BorderLayout());
        this.theFrame.add((Component)this.getContentPane(), "Center");
        this.theFrame.pack();
        this.theFrame.setVisible(true);
        return this.theFrame;
    }

    public void ejectTable() {
        Settings.set("file.drive" + drive[selectedDrive], null);
        this.model.setRowCount(0);
        this.info.setText("");
        if (this.dskFile != null) {
            this.setTitle("CPC Dsk Manager - " + this.dskFile.file.getName());
        } else {
            this.setTitle("CPC Dsk Manager");
        }
        if (this.theFrame != null) {
            this.theFrame.setTitle(this.getTitle());
        }
        this.table.setBackground(Color.LIGHT_GRAY);
    }

    public static void main(String[] args) throws SecurityException, IOException {
        try {
            try {
                UIManager.setLookAndFeel("com.pagosoft.plaf.PgsLookAndFeel");
            }
            catch (Exception exception) {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if ("Nimbus".equals(info.getName())) {
                        UIManager.setLookAndFeel(info.getClassName());
                    }
                    if (!"Windows".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DskManagerEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DskManagerEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DskManagerEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DskManagerEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (args.length == 0 || args.length == 1 && args[0].toUpperCase().endsWith(".DSK")) {
            jFrame = new DskManagerEditor();
            jFrame.getDskManagerFrame();
            if (args.length == 1) {
                File f = new File(args[0]);
                DskManagerEditor.jFrame.dskFile = DskManagerEditor.jFrame.dm.loadDsk(new File(f.getParent()), f.getName());
                if (DskManagerEditor.jFrame.dskFile == null || DskManagerEditor.jFrame.dskFile.master.type == null) {
                    jFrame.ejectTable();
                } else {
                    jFrame.updateTable();
                    Settings.set("last_path", f.getParent());
                    Settings.set("file.drive" + drive[selectedDrive], f.getParent() + File.separator + f.getName());
                }
            }
        } else {
            DskManagerConsole console = new DskManagerConsole();
            console.execute(args);
        }
    }

    static {
        System.setProperty("java.util.logging.config", "c:\\logging.properties");
    }
}

